/**************************************************/
/*  MTU2を使った演習　その２                      */
/**************************************************/

#include "7080S.H"
#include "typedef.h"
#include "libmemes.h"

// ------------------------------------------------------------
#define ex1
// ------------------------------------------------------------


#define	SW6 	(PD.DR.BIT.B18)
#define	SW5 	(PD.DR.BIT.B17)
#define	SW4 	(PD.DR.BIT.B16)
#define	SW_ON	(1)
#define	SW_OFF	(0)

#define	LED6	(PE.DR.BIT.B11)
#define	LED_ON	(0)
#define	LED_OFF	(1)

#define	DIG1	(PE.DR.BIT.B3)
#define	DIG10	(PE.DR.BIT.B2)
#define	DIG100	(PE.DR.BIT.B1)

#define	SPK	(PE.DR.BIT.B0)

#define LCD_RS		(PA.DR.BIT.B22)
#define LCD_E		(PA.DR.BIT.B23)
#define LCD_RW		(PD.DR.BIT.B23)
#define LCD_DATA	(PD.DR.BYTE.HH)

// ------------------------------------------------------------
// -- 使用する関数群 --
// ------------------------------------------------------------
void wait_us(unsigned int us) {
	unsigned int val;

	if (us <= 3)
		val = 1;
	else
		val = us * 10 / 16 - 1;

	if (val >= 0xffff)
		val = 0xffff;

	CMT0.CMCNT = 0;			// CMCNT をクリア
	CMT0.CMCOR = val;
	CMT0.CMCSR.BIT.CMF &= 0;
	CMT.CMSTR.BIT.STR0 = 1;

	while (CMT0.CMCSR.BIT.CMF == 0)
		;
	CMT0.CMCSR.BIT.CMF = 0;
	CMT.CMSTR.BIT.STR0 = 0;
}

void LCD_inst(_SBYTE inst) {
	LCD_E = 0;
	LCD_RS = 0;
	LCD_RW = 0;
	LCD_E = 1;
	LCD_DATA = inst;
	wait_us(1);
	LCD_E = 0;
	wait_us(40);
}

void LCD_data(_SBYTE data) {
	LCD_E = 0;
	LCD_RS = 1;
	LCD_RW = 0;
	LCD_E = 1;
	LCD_DATA = data;
	wait_us(1);
	LCD_E = 0;
	wait_us(40);
}

void LCD_cursor(_UINT x, _UINT y) {
	if (x > 15)
		x = 15;
	if (y > 1)
		y = 1;
	LCD_inst(0x80 | x | y << 6);
}

void LCD_putch(_SBYTE ch) {
	LCD_data(ch);
}

void LCD_putstr(_SBYTE *str) {
	_SBYTE ch;

	while (ch = *str++)
		LCD_putch(ch);
}

void LCD_cls(void) {
	LCD_inst(0x01);
	wait_us(1640);
}

void LCD_init(void) {
	wait_us(45000);
	LCD_inst(0x30);
	wait_us(4100);
	LCD_inst(0x30);
	wait_us(100);
	LCD_inst(0x30);
	
	LCD_inst(0x38);
	LCD_inst(0x08);
	LCD_inst(0x01);
	wait_us(1640);
	LCD_inst(0x06);
	LCD_inst(0x0c);
}

void init_peior(void) {
	PFC.PEIORL.BIT.B1 = 1;
	PFC.PEIORL.BIT.B2 = 1;
	PFC.PEIORL.BIT.B3 = 1;
}

void init_paior(void) {
	PFC.PAIORH.BYTE.L |= 0x0F;
}

void init_pdior(void) {
	PFC.PDIORH.BIT.B16 = 0;
	PFC.PDIORH.BIT.B17 = 0;
	PFC.PDIORH.BIT.B18 = 0;
}

// -- 7seg 表示関数 --
//	この関数が呼ばれるたびに、1 の位表示 -> 10 の位 -> 100 の位 -> 1 の位
//	のように桁を切り替えて表示する
//	この関数内では時間待ちをしていない
void do_7seg(int num)
{
	static int keta;

	DIG1 = DIG10 = DIG100 = 0;		// 全桁消灯
	PA.DR.BYTE.HL &= 0xf0;
	if (keta == 0) {
		// 最下位桁
		PA.DR.BYTE.HL |= num % 10;
		DIG1 = 1;
		keta++;
	} else if (keta == 1) {
		PA.DR.BYTE.HL |= (num % 100) / 10;
		DIG10 = 1;
		keta++;
	} else {
		// 最上位桁
		PA.DR.BYTE.HL |= num / 100;
		DIG100 = 1;
		keta = 0;
	}
}

// ------------------------------------------------------------
// -- メイン関数 --
// ------------------------------------------------------------
void main()
{
#ifdef ex1
	// -- 演習１ --
	STB.CR4.BIT._AD0 = 0;
	STB.CR4.BIT._MTU2 = 0;

	MTU20.TCR.BIT.TPSC = 3;			// 1/64選択
	MTU20.TCR.BIT.CCLR = 1;			// TGRAのコンペアマッチでクリア
	MTU20.TGRA = 31250 - 1;			// 100ms
	MTU20.TIER.BIT.TTGE = 1;		// A/D変換開始要求を許可

	AD0.ADCSR.BIT.ADM = 0;			// シングルモード
	AD0.ADCSR.BIT.CH = 0;			// AN0
	AD0.ADCSR.BIT.TRGE = 1;			// MTU2からのトリガ有効
	AD0.ADTSR.BIT.TRG0S = 1;		// TGRAコンペアマッチでトリガ

	MTU2.TSTR.BIT.CST0 = 1;			// MTU2 CH0スタート
	while (1) {
		if (AD0.ADCSR.BIT.ADF) {
			AD0.ADCSR.BIT.ADF = 0;		// フラグクリア
			printf("AN0 = %d\n", AD0.ADDR0 >> 8);
		}
	}
#endif

#ifdef ex2
	int val;

	// -- 演習２ --
	STB.CR4.BIT._AD0 = 0;
	STB.CR4.BIT._CMT = 0;
	STB.CR4.BIT._MTU2 = 0;

	CMT0.CMCSR.BIT.CKS = 1;

	MTU20.TCR.BIT.TPSC = 3;		// 1/64選択
	MTU20.TCR.BIT.CCLR = 1;		// TGRAのコンペアマッチでクリア
	MTU20.TGRA = 31250 - 1;		// 100ms
	MTU20.TIER.BIT.TTGE = 1;	// A/D変換開始要求を許可

	AD0.ADCSR.BIT.ADM = 0;		// シングルモード
	AD0.ADCSR.BIT.CH = 0;		// AN0
	AD0.ADCSR.BIT.TRGE = 1;		// MTU2からのトリガ有効
	AD0.ADTSR.BIT.TRG0S = 1;	// TGRAコンペアマッチでトリガ

	LCD_init();
	LCD_cls();
	LCD_cursor(4, 0);
	LCD_putstr("AN0 = ");

	MTU2.TSTR.BIT.CST0 = 1;		// MTU2 CH0スタート
	while (1) {
		if (AD0.ADCSR.BIT.ADF) {	// 変換終了ならば
			// 1. フラグクリア
			// 2. A/D 値取得
			// 3. LCD 表示
		}
	}
#endif

#ifdef ex3
	int val;

	// -- 演習３ --
	STB.CR4.BIT._AD0 = 0;
	STB.CR4.BIT._CMT = 0;
	STB.CR4.BIT._MTU2 = 0;

	CMT0.CMCSR.BIT.CKS = 1;

	MTU20.TCR.BIT.TPSC = 3;		// 1/64選択
	MTU20.TCR.BIT.CCLR = 1;		// TGRAのコンペアマッチでクリア
	MTU20.TGRA = 31250 - 1;		// 100ms
	MTU20.TIER.BIT.TTGE = 1;	// A/D変換開始要求を許可

	AD0.ADCSR.BIT.ADM = 0;		// シングルモード
	AD0.ADCSR.BIT.CH = 0;		// AN0
	AD0.ADCSR.BIT.TRGE = 1;		// MTU2からのトリガ有効
	AD0.ADTSR.BIT.TRG0S = 1;	// TGRAコンペアマッチでトリガ

	// 7seg 用の端子設定
	init_peior();
	init_paior();

	// 7seg 表示用の CMT1（ダイナミック点灯のため)
	CMT1.CMCSR.BIT.CKS = 0;		// 1/8
	CMT1.CMCOR = 12500 - 1;		// 5ms
	CMT.CMSTR.BIT.STR1 = 1;		// CMT1 スタート

	MTU2.TSTR.BIT.CST0 = 1;		// MTU2 CH0スタート
	while (1) {
		if (AD0.ADCSR.BIT.ADF) {	// 変換終了ならば
			// 1.フラグクリア
			// 2. A/D 値取得
		}
		// 10ms ごと 7segLED 桁切り替え(CMT1 のコンペアマッチ)
	}
#endif

#ifdef ex4
	int val;

	// -- 演習４ --
	STB.CR4.BIT._AD0 = 0;
	STB.CR4.BIT._CMT = 0;
	STB.CR4.BIT._MTU2 = 0;

	CMT0.CMCSR.BIT.CKS = 1;

#endif

#ifdef ex5
	int val;
	int TGRA_org;

	// -- 演習４ --
	STB.CR4.BIT._AD0 = 0;
	STB.CR4.BIT._CMT = 0;
	STB.CR4.BIT._MTU2 = 0;
	PFC.PEIORL.BIT.B0 = 1;

	CMT0.CMCSR.BIT.CKS = 1;

	MTU20.TCR.BIT.TPSC = 0;			// 1/1選択
	MTU20.TCR.BIT.CCLR = 1;			// TGRAのコンペアマッチでクリア
	TGRA_org = 10000 - 1;			// 500us -> 保存しておく
	MTU20.TGRA = TGRA_org;
	MTU20.TIER.BIT.TTGE = 1;		// A/D変換開始要求を許可

#endif
}
