/**************************************************/
/*  MTU2を使った演習　その１                      */
/**************************************************/

#include "7080S.H"
#include "typedef.h"

// ------------------------------------------------------------
#define ex2
// ------------------------------------------------------------

#define	SW6 	(PD.DR.BIT.B18)
#define	SW5 	(PD.DR.BIT.B17)
#define	SW4 	(PD.DR.BIT.B16)
#define	SW_ON	(1)
#define	SW_OFF	(0)

#define	LED6	(PE.DR.BIT.B11)
#define	LED_ON	(0)
#define	LED_OFF	(1)

#define	SPK	(PE.DR.BIT.B0)

#define LCD_RS		(PA.DR.BIT.B22)
#define LCD_E		(PA.DR.BIT.B23)
#define LCD_RW		(PD.DR.BIT.B23)
#define LCD_DATA	(PD.DR.BYTE.HH)

// ------------------------------------------------------------
// -- 使用する関数群 --
// ------------------------------------------------------------
void wait_us(unsigned int us) {
	unsigned int val;

	if (us <= 3)
		val = 1;
	else
		val = us * 10 / 16 - 1;

	if (val >= 0xffff)
		val = 0xffff;

	CMT0.CMCNT = 0;			// CMCNT をクリア
	CMT0.CMCOR = val;
	CMT0.CMCSR.BIT.CMF &= 0;
	CMT.CMSTR.BIT.STR0 = 1;

	while (CMT0.CMCSR.BIT.CMF == 0)
		;
	CMT0.CMCSR.BIT.CMF = 0;
	CMT.CMSTR.BIT.STR0 = 0;
}

void LCD_inst(_SBYTE inst) {
	LCD_E = 0;
	LCD_RS = 0;
	LCD_RW = 0;
	LCD_E = 1;
	LCD_DATA = inst;
	wait_us(1);
	LCD_E = 0;
	wait_us(40);
}

void LCD_data(_SBYTE data) {
	LCD_E = 0;
	LCD_RS = 1;
	LCD_RW = 0;
	LCD_E = 1;
	LCD_DATA = data;
	wait_us(1);
	LCD_E = 0;
	wait_us(40);
}

void LCD_cursor(_UINT x, _UINT y) {
	if (x > 15)
		x = 15;
	if (y > 1)
		y = 1;
	LCD_inst(0x80 | x | y << 6);
}

void LCD_putch(_SBYTE ch) {
	LCD_data(ch);
}

void LCD_putstr(_SBYTE *str) {
	_SBYTE ch;

	while (ch = *str++)
		LCD_putch(ch);
}

void LCD_cls(void) {
	LCD_inst(0x01);
	wait_us(1640);
}

void LCD_init(void) {
	wait_us(45000);
	LCD_inst(0x30);
	wait_us(4100);
	LCD_inst(0x30);
	wait_us(100);
	LCD_inst(0x30);
	
	LCD_inst(0x38);
	LCD_inst(0x08);
	LCD_inst(0x01);
	wait_us(1640);
	LCD_inst(0x06);
	LCD_inst(0x0c);
}


// ------------------------------------------------------------
// -- メイン関数 --
// ------------------------------------------------------------
void main()
{
#ifdef ex2
	// -- 演習２ --
	STB.CR4.BIT._MTU2 = 0;
	PFC.PEIORL.BIT.B0 = 1;

	MTU20.TCR.BIT.TPSC = 0;		// カウントクロックは PΦ/1 = 20MHz
	MTU20.TCR.BIT.CCLR = 1;		// TCNTはTGRAのコンペアマッチでクリア
	MTU20.TGRA = 0;		// <--- ?

	SPK = 0;
	MTU2.TSTR.BIT.CST0 = 1;		// カウント開始
	while (1) {
		// -- if 文を使う（おすすめ） --
		if (0) {	// <--- ?
			MTU20.TSR.BIT.TGFA = 0;
			SPK ^= 1;
		}
	}
#endif

#ifdef ex3
	// -- 演習３ --
	int i;

	STB.CR4.BIT._MTU2 = 0;
	PFC.PEIORL.BIT.B11 = 1;

	// ここに MTU20 設定を追加


	LED6 = LED_ON;
	MTU2.TSTR.BIT.CST0 = 1;		// カウント開始

	// -- 1 秒待つ --
	for (i = 0; i < 10;) {
		// コンペアマッチが発生したら
		// 1. フラグクリア
		// 2. i インクリメント
	}
	LED6 = LED_OFF;

	while (1);
#endif

#ifdef ex4
	// -- 演習４ --
	int i;

	STB.CR4.BIT._MTU2 = 0;
	PFC.PEIORL.BIT.B11 = 1;

	// ここに MTU20 設定を追加


	LED6 = LED_ON;
	MTU2.TSTR.BIT.CST0 = 1;		// カウント開始
	while (1) {
		// -- 500ms 待つ --
		for (i = 0; i < 5;) {
			// コンペアマッチが発生したら
			// 1. フラグクリア
			// 2. i インクリメント
		}
		LED6 ^= 1;
	}
#endif

#ifdef ex5
	// -- 演習５ --
	int count;

	STB.CR4.BIT._MTU2 = 0;
	STB.CR4.BIT._CMT = 0;
	CMT0.CMCSR.BIT.CKS = 1;		// CMT は LCD 用

	// ここに MTU20 設定を追加


	LCD_init();
	count = 0;
	MTU2.TSTR.BIT.CST0 = 1;		// カウント開始
	while (1) {
		// コンペアマッチが発生したら
		// 1.フラグクリア
		// 2. count インクリメント
		// 3. LCD 表示
	}
#endif

#ifdef ex6
	// -- 演習６ --
	int count;

	STB.CR4.BIT._MTU2 = 0;
	STB.CR4.BIT._CMT = 0;
	CMT0.CMCSR.BIT.CKS = 1;

	// ここに MTU20 設定を追加


	LCD_init();
	LCD_cursor(7, 0);
	LCD_putstr("00.0");
	count = 0;
	while (1) {
		if (SW4 == SW_ON) {
			// -- リセット --
			// 1. count 初期化
			// 2. LCD 表示初期化
		}

		if (SW5 == SW_ON)
			// -- カウント停止 --

		if (SW6 == SW_ON)
			// -- カウント開始 --
			MTU2.TSTR.BIT.CST0 = 1;		// カウント開始

		if (MTU20.TSR.BIT.TGFA) {
			// コンペアマッチ発生
			// 1. フラグクリア
			// 2. count インクリメント
			// 3. LCD 表示
		}
	}
#endif
}
