/*****************************************************************/
/*  A/D変換器の連続スキャンモードを使った演習                    */
/*****************************************************************/

#include "7080S.H"
#include "libmemes.h"
#include "typedef.h"

#define ex1

#define	SW6 (PD.DR.BIT.B18)
#define	SW4 (PD.DR.BIT.B16)
#define SW_ON   (1)
#define SW_OFF  (0)

#define LCD_RS		(PA.DR.BIT.B22)
#define LCD_E		(PA.DR.BIT.B23)
#define LCD_RW		(PD.DR.BIT.B23)
#define LCD_DATA	(PD.DR.BYTE.HH)

void wait_us(_UINT us) {
	_UINT val;

	val = us * 10 / 16;
	if (val >= 0xffff)
		val = 0xffff;

	CMT0.CMCOR = val;
	CMT0.CMCSR.BIT.CMF &= 0;
	CMT.CMSTR.BIT.STR0 = 1;
	while (!CMT0.CMCSR.BIT.CMF);
	CMT0.CMCSR.BIT.CMF = 0;
	CMT.CMSTR.BIT.STR0 = 0;
}

void LCD_inst(_SBYTE inst) {
	LCD_E = 0;
	LCD_RS = 0;
	LCD_RW = 0;
	LCD_E = 1;
	LCD_DATA = inst;
	wait_us(1);
	LCD_E = 0;
	wait_us(40);
}

void LCD_data(_SBYTE data) {
	LCD_E = 0;
	LCD_RS = 1;
	LCD_RW = 0;
	LCD_E = 1;
	LCD_DATA = data;
	wait_us(1);
	LCD_E = 0;
	wait_us(40);
}

void LCD_cursor(_UINT x, _UINT y) {
	if (x > 15)
		x = 15;
	if (y > 1)
		y = 1;
	LCD_inst(0x80 | x | y << 6);
}

void LCD_putch(_SBYTE ch) {
	LCD_data(ch);
}

void LCD_putstr(_SBYTE *str) {
	_SBYTE ch;

	while (ch = *str++)
		LCD_putch(ch);
}

void LCD_cls(void) {
	LCD_inst(0x01);
	wait_us(1640);
}

void LCD_init(void) {
	wait_us(45000);
	LCD_inst(0x30);
	wait_us(4100);
	LCD_inst(0x30);
	wait_us(100);
	LCD_inst(0x30);
	
	LCD_inst(0x38);
	LCD_inst(0x08);
	LCD_inst(0x01);
	wait_us(1640);
	LCD_inst(0x06);
	LCD_inst(0x0c);
}

// ------------------------------------------------------------
// ------------------------------------------------------------
#ifdef ex1
void main(void) {
	STB.CR4.BIT._AD0 = 0;
	STB.CR4.BIT._CMT = 0;
	CMT0.CMCSR.BIT.CKS = 1;		// 1/32

	AD0.ADCSR.BIT.ADM = 3;		// 2chスキャンモード
	AD0.ADCSR.BIT.ADCS = 1;		// 連続スキャンモード
	AD0.ADCSR.BIT.CH = 1;		// AN0, AN1を変換
	AD0.ADCR.BIT.ADST = 1;		// 変換開始
	while (1) {
		while (!AD0.ADCSR.BIT.ADF)
			;
		AD0.ADCSR.BIT.ADF = 0;
		printf("ADDR0 = %04d : ADDR1 = %04d\n",
			AD0.ADDR0 >> 6, AD0.ADDR1 >> 6);
		wait_us(10000);
	}
}
#endif

#ifdef ex2
void main(void) {
	STB.CR4.BIT._AD0 = 0;
	STB.CR4.BIT._CMT = 0;
	CMT0.CMCSR.BIT.CKS = 1;		// 1/32

	AD0.ADCSR.BIT.ADM = 3;		// 2chスキャンモード
	AD0.ADCSR.BIT.ADCS = 1;		// 連続スキャンモード
	AD0.ADCSR.BIT.CH = 1;		// AN0, AN1を変換

	while (1) {
		// -- ここから編集 --

		// -- ここまで --
	}
}
#endif

#ifdef ex3
void main(void) {
	_UWORD	ad_rst = 0;
	_SBYTE	str[16] = {' ',' ','A','D','D','R','0',' ','=',' ','0','0','0',' ',' ','\0'};
	STB.CR4.BIT._AD0 = 0;
	STB.CR4.BIT._CMT = 0;
	CMT0.CMCSR.BIT.CKS = 1;		// 1/32

	LCD_init();

	AD0.ADCSR.BIT.ADM = 3;		// 2chスキャンモード
	AD0.ADCSR.BIT.ADCS = 1;		// 連続スキャンモード
	AD0.ADCSR.BIT.CH = 1;		// AN0, AN1を変換

	LCD_cursor(0, 0);
	LCD_putstr(str);		// "ADDR0 ="
	LCD_cursor(0, 1);
	LCD_putstr(str);		// "ADDR0 ="
	LCD_cursor(6, 1);
	LCD_putch('1');			// "ADDR1 ="に書き換え

	while (1) {
		// -- ここから編集 --

		// -- ここまで --
	}
}
#endif

#ifdef ex4
void main(void) {
	_UWORD	ad_rst = 0;
	_SBYTE	str[16] = {' ',' ','A','D','D','R','0',' ','=',' ','0','0','0',' ',' ','\0'};
	STB.CR4.BIT._AD0 = 0;
	STB.CR4.BIT._CMT = 0;

	CMT0.CMCSR.BIT.CKS = 1;

	LCD_init();

	AD0.ADCSR.BIT.ADM = 3;		// 2chスキャンモード
	AD0.ADCSR.BIT.ADCS = 1;		// 連続スキャンモード
	AD0.ADCSR.BIT.CH = 1;		// AN0, AN1を変換

	LCD_cursor(0, 0);
	LCD_putstr(str);
	LCD_cursor(0, 1);
	LCD_putstr(str);
	LCD_cursor(6, 1);
	LCD_putch('1');

	// -- CMT1 を 500ms に設定 --
	CMT1.CMCSR.BIT.CKS = 3;		// 1/512
	CMT1.CMCOR = 19531 - 1;		// 500ms
	CMT1.CMCSR.BIT.CMF &= 0;

	while (1) {
		// -- ここから編集 --

		// -- ここまで --
	}
}
#endif
