/***********************************************************************/
/*  A/D変換器の１サイクルスキャンモードを使った演習                    */
/***********************************************************************/
#include "7080S.H"
#include "libmemes.h"
#include "typedef.h"

#define ex1

#define	SW6 (PD.DR.BIT.B18)

#define LCD_RS		(PA.DR.BIT.B22)
#define LCD_E		(PA.DR.BIT.B23)
#define LCD_RW		(PD.DR.BIT.B23)
#define LCD_DATA	(PD.DR.BYTE.HH)

void wait_us(_UINT us) {
	_UINT val;

	if (us <= 3)
		val = 1;
	else
		val = us * 10 / 16 - 1;

	if (val >= 0xffff)
		val = 0xffff;

	CMT0.CMCNT = 0;
	CMT0.CMCOR = val;
	CMT0.CMCSR.BIT.CMF &= 0;
	CMT.CMSTR.BIT.STR0 = 1;
	while (CMT0.CMCSR.BIT.CMF == 0)
		;
	CMT0.CMCSR.BIT.CMF = 0;
	CMT.CMSTR.BIT.STR0 = 0;
}

void LCD_inst(_SBYTE inst) {
	LCD_E = 0;
	LCD_RS = 0;
	LCD_RW = 0;
	LCD_E = 1;
	LCD_DATA = inst;
	wait_us(1);
	LCD_E = 0;
	wait_us(40);
}

void LCD_data(_SBYTE data) {
	LCD_E = 0;
	LCD_RS = 1;
	LCD_RW = 0;
	LCD_E = 1;
	LCD_DATA = data;
	wait_us(1);
	LCD_E = 0;
	wait_us(40);
}

void LCD_cursor(_UINT x, _UINT y) {
	if (x > 15)
		x = 15;
	if (y > 1)
		y = 1;
	LCD_inst(0x80 | x | y << 6);
}

void LCD_putch(_SBYTE ch) {
	LCD_data(ch);
}

void LCD_putstr(_SBYTE *str) {
	_SBYTE ch;

	while (ch = *str++)
		LCD_putch(ch);
}

void LCD_cls(void) {
	LCD_inst(0x01);
	wait_us(1640);
}

void LCD_init(void) {
	wait_us(45000);
	LCD_inst(0x30);
	wait_us(4100);
	LCD_inst(0x30);
	wait_us(100);
	LCD_inst(0x30);
	
	LCD_inst(0x38);
	LCD_inst(0x08);
	LCD_inst(0x01);
	wait_us(1640);
	LCD_inst(0x06);
	LCD_inst(0x0c);
}

// ------------------------------------------------------------
// ------------------------------------------------------------
#ifdef ex1
void main(void) {
	STB.CR4.BIT._AD0 = 0;
	AD0.ADCSR.BIT.ADM = 3;		// 2チャネルスキャンモード
	AD0.ADCSR.BIT.CH = 1;		// AN0 と AN1
	AD0.ADCR.BIT.ADST = 1;
	while(AD0.ADCR.BIT.ADST);
	AD0.ADCSR.BIT.ADF = 0;
	printf("ADDR0 = %04d \nADDR1 = %04d\n",
			AD0.ADDR0 >> 6, AD0.ADDR1 >> 6);
	while(1);
}
#endif

#ifdef ex2
void main(void) {
	STB.CR4.BIT._AD0 = 0;
	// -- ここから編集 --

	// -- ここまで --
	while(1);
}
#endif

#ifdef ex3
void main(void) {
	STB.CR4.BIT._AD0 = 0;
	// -- ここから編集 --

	// -- ここまで --
	while(1);
}
#endif

#ifdef ex4
void main(void) {
	_UWORD	ad_rst = 0;
	_SBYTE	str[16] = {' ',' ','A','D','D','R','0',' ','=',' ','0','0','0',' ',' ','\0'};

	STB.CR4.BIT._AD0 = 0;
	STB.CR4.BIT._CMT = 0;
	CMT0.CMCSR.BIT.CKS = 1;		// 1/32
	// -- ここから編集 --

	// -- ここまで --
	while(1);
}
#endif

