/***********************************************************************/
/*  A/D変換器のシングルスキャンモードを使った演習                      */
/***********************************************************************/

#include "7080S.H"
#include "typedef.h"
#include "libmemes.h"

// ------------------------------------------------------------
// 演習番号の切り替え(ex1, ex2, ex3, ex4, ex5, ex6, ex7)
#define ex1
// ------------------------------------------------------------

#define	SW6 (PD.DR.BIT.B18)
#define	SW4 (PD.DR.BIT.B16)
#define	SW_ON	(1)
#define	SW_OFF	(0)

#define  DIG1	(PE.DR.BIT.B3)
#define  DIG10	(PE.DR.BIT.B2)
#define  DIG100	(PE.DR.BIT.B1)

#define LCD_RS		(PA.DR.BIT.B22)
#define LCD_E		(PA.DR.BIT.B23)
#define LCD_RW		(PD.DR.BIT.B23)
#define LCD_DATA	(PD.DR.BYTE.HH)

// ------------------------------------------------------------
// -- 演習で使用する関数群 --

void disp_led(_SINT digit, _UINT ad_rst) {
	DIG1 = DIG10 = DIG100 = 0;
	PA.DR.BYTE.HL &= 0xf0;
	if (digit == 0) {
		PA.DR.BYTE.HL |= ad_rst % 10;
		DIG1 = 1;
	} else if (digit == 1) {
		PA.DR.BYTE.HL |= (ad_rst / 10) % 10;
		DIG10 = 1;
	} else {
		PA.DR.BYTE.HL |= (ad_rst / 100) % 10;
		DIG100 = 1;
	}
}

void wait_us(_UINT us) {
	_UINT val;

	CMT0.CMCSR.BIT.CKS = 1;
	val = us * 10 / 16;
	if (val >= 0xffff)
		val = 0xffff;

	CMT0.CMCNT = 0;
	CMT0.CMCOR = val;
	CMT0.CMCSR.BIT.CMF &= 0;
	CMT.CMSTR.BIT.STR0 = 1;
	while (!CMT0.CMCSR.BIT.CMF);
	CMT0.CMCSR.BIT.CMF = 0;
	CMT.CMSTR.BIT.STR0 = 0;
}

void LCD_inst(_SBYTE inst) {
	LCD_E = 0;
	LCD_RS = 0;
	LCD_RW = 0;
	LCD_E = 1;
	LCD_DATA = inst;
	wait_us(1);
	LCD_E = 0;
	wait_us(40);
}

void LCD_data(_SBYTE data) {
	LCD_E = 0;
	LCD_RS = 1;
	LCD_RW = 0;
	LCD_E = 1;
	LCD_DATA = data;
	wait_us(1);
	LCD_E = 0;
	wait_us(40);
}

void LCD_cursor(_UINT x, _UINT y) {
	if (x > 15)
		x = 15;
	if (y > 1)
		y = 1;
	LCD_inst(0x80 | x | y << 6);
}

void LCD_putch(_SBYTE ch) {
	LCD_data(ch);
}

void LCD_putstr(_SBYTE *str) {
	_SBYTE ch;

	while (ch = *str++)
		LCD_putch(ch);
}

void LCD_cls(void) {
	LCD_inst(0x01);
	wait_us(1640);
}

void LCD_init(void) {
	wait_us(45000);
	LCD_inst(0x30);
	wait_us(4100);
	LCD_inst(0x30);
	wait_us(100);
	LCD_inst(0x30);
	
	LCD_inst(0x38);
	LCD_inst(0x08);
	LCD_inst(0x01);
	wait_us(1640);
	LCD_inst(0x06);
	LCD_inst(0x0c);
}

// ------------------------------------------------------------
// -- メイン --
void main(void) {
#ifdef ex1
	STB.CR4.BIT._AD0 = 0;
	AD0.ADCR.BIT.ADST = 1;
	while(AD0.ADCR.BIT.ADST)
		;
	AD0.ADCSR.BIT.ADF = 0;
	printf("ADDR0 = %04d \n", AD0.ADDR0 >> 6);
	while(1)
		;
#endif

#ifdef ex2
	// -- 演習２ --
	STB.CR4.BIT._AD0 = 0;
#endif

#ifdef ex3
	// -- 演習３ --
	STB.CR4.BIT._AD0 = 0;
#endif

#ifdef ex4
	STB.CR4.BIT._AD0 = 0;
#endif

#ifdef ex5
	// -- 演習５ --
	STB.CR4.BIT._AD0 = 0;
#endif

#ifdef ex6
	// -- 演習６ --
	_UWORD	ad_rst = 0;
	_SINT	keta = 0;
	STB.CR4.BIT._AD0 = 0;
	STB.CR4.BIT._CMT = 0;
#endif

#ifdef ex7
	_UWORD	ad_rst = 0;
	STB.CR4.BIT._AD0 = 0;
	STB.CR4.BIT._CMT = 0;
#endif
}
