/*
 * lcd2.c
 *
 */

#include "libmemes.h"
#include <7080S.H>

#define LCD_RS		(PA.DR.BIT.B22)
#define LCD_E		(PA.DR.BIT.B23)
#define LCD_RW		(PD.DR.BIT.B23)
#define LCD_DATA	(PD.DR.BYTE.HH)

void wait_us(unsigned int);
void LCD_inst(char);
void LCD_data(char);

/********************************************************/
void LCD_init() {
	wait_us(45000);
	LCD_inst(0x30);
	wait_us(4100);
	LCD_inst(0x30);
	wait_us(100);
	LCD_inst(0x30);
	
	LCD_inst(0x38);
	LCD_inst(0x08);
	LCD_inst(0x01);
	wait_us(1640);
	LCD_inst(0x06);
	LCD_inst(0x0c);
}
/********************************************************/
void wait_us(unsigned int us) {
	unsigned int val;

	val = us * 10 / 16;
	if (val >= 0xffff)
		val = 0xffff;

	CMT0.CMCOR = val;
	CMT0.CMCSR.BIT.CMF &= 0;
	CMT.CMSTR.BIT.STR0 = 1;

	while (CMT0.CMCSR.BIT.CMF == 0)
		;
	CMT0.CMCSR.BIT.CMF = 0;
	CMT.CMSTR.BIT.STR0 = 0;
}
/********************************************************/
void LCD_cursor(unsigned int x, unsigned int y) {
	if (x > 15)
		x = 15;

	if (y > 1)
		y = 1;

	LCD_inst(0x80 | x | y << 6);
}
/********************************************************/
void LCD_putch(char ch) {
	LCD_data(ch);
}
/********************************************************/
void LCD_putstr(char *str) {
	char ch;

	while (ch = *str++)
		LCD_putch(ch);
}
/********************************************************/
/* LCD モジュールにインストラクションコードを書き込む */
/********************************************************/
void LCD_inst(char inst) {
	LCD_E = 0;
	LCD_RS = 0;
	LCD_RW = 0;
	LCD_E = 1;
	LCD_DATA = inst;
	wait_us(1);
	LCD_E = 0;
	wait_us(40);
}
/********************************************************/
/* LCD モジュールにデータを書き込む */
/********************************************************/
void LCD_data(char data) {
	LCD_E = 0;
	LCD_RS = 1;
	LCD_RW = 0;
	LCD_E = 1;
	LCD_DATA = data;
	wait_us(1);
	LCD_E = 0;
	wait_us(40);
}
/********************************************************/
void LCD_cls() {
	LCD_inst(0x01);
	wait_us(1640);
}
/********************************************************/
void main() {
	unsigned int x, y;
	char str[16];

	PFC.PAIORH.BIT.B22 = 1;
	PFC.PAIORH.BIT.B23 = 1;
	PFC.PDIORH.BIT.B23 = 1;
	PFC.PDIORH.BYTE.H = 0xff;

	STB.CR4.BIT._CMT = 0;
	CMT0.CMCSR.BIT.CKS = 1;		// 1/32

	CMT1.CMCSR.BIT.CKS = 3;		// 1/512
	CMT1.CMCOR = 19530;		// 500ms

	LCD_init();

	while (1) {
		printf("X Y String : ");
		scanf("%d %d %s", &x, &y, str);

#if 1
		// -- 演習７ --

#else
		// -- 演習８ --

#endif
	}
}
