/*
 * lcd1.c
 *
 */

#include "libmemes.h"
#include <7080S.H>

#define LCD_RS		(PA.DR.BIT.B22)
#define LCD_E		(PA.DR.BIT.B23)
#define LCD_RW		(PD.DR.BIT.B23)
#define LCD_DATA	(PD.DR.BYTE.HH)

void wait_us(unsigned int);
void LCD_inst(char);
void LCD_data(char);

/********************************************************/
void LCD_init() {
	// -- 演習１ --
}
/********************************************************/
void wait_us(unsigned int us) {
#if 0
	// -- 演習３ --
	unsigned int val;

	CMT0.CMCSR.BIT.CKS = 1;
	val = ???;
	if (val >= 0xffff)
		// -- 値制限 --
		val = 0xffff;
	CMT0.CMCOR = val;
	CMT0.CMCSR.BIT.CMF = 0;		// CMF クリア
	CMT.___.___.___ = 1;		// CMT0 スタート
	while (___)			// CMF == 1 を待つ
		;
	CMT0.CMCSR.BIT.CMF = 0;		// CMF クリア
	CMT.___.___.___ = 0;		// CMT0 ストップ
#else
	for (; us > 0; us--) {
		nop();
		nop();
		nop();
		nop();
	}
#endif
}
/********************************************************/
void LCD_cursor(unsigned int x, unsigned int y) {
	// -- 演習４ --
}
/********************************************************/
void LCD_putch(char ch) {
	// -- 演習５ --
}
/********************************************************/
void LCD_putstr(char *str) {
	// -- 演習６ --
}
/********************************************************/
/* LCD モジュールにインストラクションコードを書き込む */
/********************************************************/
void LCD_inst(char inst) {
	LCD_E = 0;
	LCD_RS = 0;
	LCD_RW = 0;
	LCD_E = 1;
	LCD_DATA = inst;
	LCD_E = 0;
	wait_us(40);
}
/********************************************************/
/* LCD モジュールにデータを書き込む */
/********************************************************/
void LCD_data(char data)
{
	LCD_E = 0;
	LCD_RS = 1;
	LCD_RW = 0;
	LCD_E = 1;
	LCD_DATA = data;
	LCD_E = 0;
	wait_us(40);
}
/********************************************************/
void main() {
	PFC.PAIORH.BIT.B22 = 1;
	PFC.PAIORH.BIT.B23 = 1;
	PFC.PDIORH.BIT.B23 = 1;
	PFC.PDIORH.BYTE.H = 0xff;

	STB.CR4.BIT._CMT = 0;

	LCD_init();

	LCD_inst(0x80);		// DDRAM アドレスセット(左上)
	LCD_data('A');

	// -- 演習２ : 右上に'B'表示 --

	// -- 演習２ ここまで --

	LCD_cursor(8, 0);
	LCD_data('C');

	LCD_cursor(9, 0);
	LCD_putch('D');

	LCD_cursor(10, 1);
	LCD_putstr("EFG");

	while (1)
		;
}
